/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2021 - 2023 Intel Corporation */
#ifndef IG3RDMA_HW_H
#define IG3RDMA_HW_H

#define IG3_MAX_APFS 1
#define IG3_MAX_AVFS 0
/* shifts/masks for FLD_[LS/RS]_64 macros used in device table */
#define IG3_CQPSQ_STAG_PDID_S 46
#define IG3_CQPSQ_STAG_PDID GENMASK_ULL(63, 46)
#define IG3_CQPSQ_CQ_CQID_S 0
#define IG3_CQPSQ_CQ_CQID GENMASK_ULL(21, 0)
#define IG3_CQPSQ_CQ_CEQID_S 22
#define IG3_CQPSQ_CQ_CEQID GENMASK_ULL(31, 22)

#define IG3_COMMIT_FPM_CQCNT_S 0
#define IG3_COMMIT_FPM_CQCNT GENMASK_ULL(21, 0)
#define IG3_CQPSQ_UPESD_HMCFNID_S 0
#define IG3_CQPSQ_UPESD_HMCFNID GENMASK_ULL(7, 0)

enum ig3rdma_device_caps_const {
	IG3RDMA_MAX_WQ_FRAGMENT_COUNT		= 14,
	IG3RDMA_MAX_SGE_RD			= 14,

	IG3RDMA_MAX_STATS_COUNT			= 128,

	IG3RDMA_MIN_WQ_SIZE			= 16 /* WQEs */,
	IG3RDMA_MAX_IRD_SIZE			= 128,
	IG3RDMA_MAX_ORD_SIZE			= 128,
	IG3RDMA_MAX_INLINE_DATA_SIZE		= 216,
	IG3RDMA_MAX_PF_PUSH_PAGE_COUNT		= 8192,
	IG3RDMA_MAX_VF_PUSH_PAGE_COUNT		= 16,
};

#endif /* IG3RDMA_HW_H*/
