%if 0%{?_IRDMA_SPREFIX_:1}
%define name %{_IRDMA_SPREFIX_}
%else
%define name kmod-irdma
%endif
Name: %{name}
Summary: Intel(R) Ethernet Connection E800 Series Linux iRDMA Driver
%if 0%{?_IRDMA_VER_:1}
%define version %{_IRDMA_VER_}
%else
%define version 2.0.26
%endif
%if 0%{?_IRDMA_REL_:1}
%define release %{_IRDMA_REL_}
%else
%define release 1.rhel10u0
%endif
%if 0%{?_IRDMA_SIGN_:1}
%define sign %{_IRDMA_SIGN_}
%else
%define sign 0
%endif
%if 0%{?_KERNELSRC_:1}
%{echo:INFO: _KERNELSRC_ defined}
%else
%{echo:WARNING: _KERNELSRC_ Not defined}
%define _KERNELSRC_ /usr/src/kernels/6.12.0-55.9.1.el10_0.x86_64
%endif

Version: %{version}
Release: %{release}
Source0: %{name}-%{version}.tgz
Source1: %{name}.conf
Vendor: Intel Corporation
License: GPLv2 or BSD Redistributable, no modification permitted
ExclusiveOS: linux
Group: System Environment/Kernel
Provides: %{name}
URL: http://support.intel.com
BuildRoot: %{_tmppath}/%{name}-%{version}-root
%global debug_package %{nil}
%global __strip /bin/true

%define find() %(for f in %*; do if [ -e $f ]; then echo $f; break; fi; done)
Requires: kernel, findutils, gawk, bash

# Check for existence of kernel_module_package_buildreqs ...
%if 0%{?!kernel_module_package_buildreqs:1}
# ... and provide a suitable definition if it is not defined
%define kernel_module_package_buildreqs kernel-devel
%endif

BuildRequires: %kernel_module_package_buildreqs

%description
This package contains the Intel(R) Ethernet Connection E800 Series Linux iRDMA Driver.

%prep
%setup

%build
./build.sh noinstall

# Signing
echo "Start signing ${SANDBOX_DIR}"
# Find the sign file script
if [ %{sign} -eq 0 ]; then
	wc=0
else
	wc=`find %{_topdir} -type f -name sign-file | wc -l`
fi
if [ $wc -eq 1 ]; then
	signtool=`find %{_topdir} -type f -name sign-file`
	for module in `find . -type f -name \*.ko`; do
		strip --strip-debug ${module}
		if [ -f ${signtool} ]; then
			source ${signtool} ${module}
		fi
	done
	if [ -f ${signtool} ]; then
		rm -rf ${signtool}
	fi
else
	echo "Found ${wc} binaries"
fi

%install
mkdir -p %{buildroot}/lib/modules/`uname -r`/updates/drivers/infiniband/hw/irdma/
find ./ -iname "irdma.ko" -exec install -D -m 644 {} "%{buildroot}/lib/modules/`uname -r`/updates/drivers/infiniband/hw/irdma/" \;
install -m 644 -D %{SOURCE1} "%{buildroot}/etc/depmod.d/%{name}.conf"
cd %{buildroot}
find lib -name "irdma.ko" \
	-fprintf %{_builddir}/%{name}-%{version}/file.list "/%p\n"

%clean
rm -rf %{buildroot}

%files -f file.list

%defattr(644,root,root,755)
%{_sysconfdir}/depmod.d/%{name}.conf
%doc file.list
%doc COPYING
%doc README_irdma.txt

%post

rmmod i40iw 2> /dev/null
echo "Creating /etc/modprobe.d/irdma.conf file ..."
mkdir -p "/etc/modprobe.d/"
if [ -e "/etc/modprobe.d/irdma.conf" ]; then
	if [ "" = "$(grep 'blacklist i40iw' /etc/modprobe.d/irdma.conf)" ]; then
		echo "blacklist i40iw"  >>  "/etc/modprobe.d/irdma.conf"
		echo "alias i40iw irdma" >> "/etc/modprobe.d/irdma.conf"
	fi
else
	echo "blacklist i40iw"  >  "/etc/modprobe.d/irdma.conf"
	echo "alias i40iw irdma" >> "/etc/modprobe.d/irdma.conf"
fi

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

wm="/usr/sbin/weak-modules"
if [ -x ${wm} ]; then
    modules=($(find /lib/modules -name irdma.ko))
    echo "${modules}" | ${wm} --no-initramfs --add-modules
fi

wm2="/usr/lib/module-init-tools/weak-modules2"
if [ -x ${wm2} ]; then
    kmp="%{name}-%{version}-%{release}.%{_arch}"
    ${wm2} --add-kmp ${kmp}
fi

%preun

%postun
uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

if which dracut >/dev/null 2>&1; then
	echo "Updating initramfs with dracut..."
	if dracut --force ; then
		echo "Successfully updated initramfs."
	else
		echo "Failed to update initramfs."
		echo "You must update your initramfs image for changes to take place."
		exit -1
	fi
elif which mkinitrd >/dev/null 2>&1; then
	echo "Updating initrd with mkinitrd..."
	if mkinitrd; then
		echo "Successfully updated initrd."
	else
		echo "Failed to update initrd."
		echo "You must update your initrd image for changes to take place."
		exit -1
	fi
else
	echo "Unable to determine utility to update initrd image."
	echo "You must update your initrd manually for changes to take place."
	exit -1
fi

wm="/usr/sbin/weak-modules"
if [ -x "${wm}" ]; then
    modules=($(find /lib/modules -name irdma.ko))
    echo "${modules}" | ${wm} --remove-modules
fi

wm2="/usr/lib/module-init-tools/weak-modules2"
if [ -x ${wm2} ]; then
    modules=($(find /lib/modules -name irdma.ko))
    kmp="%{name}-%{version}-%{release}.%{_arch}"
    echo "${modules}" | ${wm2} --remove-kmp ${kmp}
fi

